/********************************************************************************************
	Clean OS Windows library module version 1.2.1.
	This module is part of the Clean Object I/O library, version 1.2.1, 
	for the Windows platform.
********************************************************************************************/

/********************************************************************************************
	About this module:
	Routines related to game handling.
********************************************************************************************/
#include "cCrossCallGame_121.h"


/*	Cross call procedure implementations.
	Eval<nr> corresponds with a CrossCallEntry generated by NewCrossCallEntry (nr,Eval<nr>).
*/
void EvalCcRqRUNGAME (CrossCallInfo *pcci)				/* no args; no result. */
{
    RunGame ();
	MakeReturn0Cci (pcci);
}

void EvalCcRqPLAYSOUNDSAMPLE (CrossCallInfo *pcci)		/* id, vol, pan, freq, delay; no result. */
{
    int id    = pcci->p1;
    int vol   = pcci->p2;
    int pan   = pcci->p3;
    int freq  = pcci->p4;
    int delay = pcci->p5;

    PlaySoundSample (id, vol, pan, freq, delay);

	MakeReturn0Cci (pcci);
}

void EvalCcRqCREATEGAMEOBJECT (CrossCallInfo *pcci)		/* mapval, above, x, y; no result. */
{
    int mapval = pcci->p1;
    int above  = pcci->p2;
    int x      = pcci->p3;
    int y      = pcci->p4;
    int result = 0;

    CreateGameObject (mapval, above, x, y, &result);

	MakeReturn0Cci (pcci);
}

void EvalCcRqUSERGAMEEVENT (CrossCallInfo *pcci)		/* event, par1, par2, target, subtarget, time; no result. */
{
    int event     = pcci->p1;
    int par1      = pcci->p2;
    int par2      = pcci->p3;
    int target    = pcci->p4;
    int subtarget = pcci->p5;
    int time      = pcci->p6;

    ScheduleUserGameEvent (event, par1, par2, target, subtarget, time);

	MakeReturn0Cci (pcci);
}

void EvalCcRqCREATEGAMEWINDOW (CrossCallInfo *pcci)		/* width, height, bpp, fullscreen; HWND result */
{
    int w   = pcci->p1;
    int h   = pcci->p2;
    int bpp = pcci->p3;
    int fs  = (BOOL) pcci->p4;
    int result;

    result = CreateGameWindow (w, h, bpp, fs);

    MakeReturn1Cci (pcci, result);
}


/*	Install the cross call procedures in the gCrossCallProcedureTable of cCrossCall_121.
*/
int InstallCrossCallGame (int ios)
{
	CrossCallProcedureTable newTable;

	newTable = EmptyCrossCallProcedureTable ();
	AddCrossCallEntry (newTable, CcRqRUNGAME,          EvalCcRqRUNGAME);
	AddCrossCallEntry (newTable, CcRqPLAYSOUNDSAMPLE,  EvalCcRqPLAYSOUNDSAMPLE);
	AddCrossCallEntry (newTable, CcRqCREATEGAMEOBJECT, EvalCcRqCREATEGAMEOBJECT);
	AddCrossCallEntry (newTable, CcRqUSERGAMEEVENT,    EvalCcRqUSERGAMEEVENT);
	AddCrossCallEntry (newTable, CcRqCREATEGAMEWINDOW, EvalCcRqCREATEGAMEWINDOW);
	AddCrossCallEntries (gCrossCallProcedureTable, newTable);

	//	Register the game window class:
	RegisterGameWindowClass ();

	return ios;
}
